<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplication\Show;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserApplication
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package     Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplication\Show
 */
class UserApplication
{
    /**
     * @Serializer\SerializedName("Show")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplication\Show\Show")
     *
     * @var Show
     */
    private $show;

    /**
     * @param string $identifier
     * @param integer|null $applicationActive
     */
    public function setUserApplication($identifier, $applicationActive = null)
    {
        $show = new Show();
        $key = new Key();
        $userType = new UserType();


        $userType->setIdentifier($identifier);
        $key->setUserType($userType);

        if ($applicationActive !== null) {
            $applicationType = new ApplicationType();
            $applicationType->setActive($applicationActive);

            $key->setApplicationType($applicationType);
        }

        $show->setKey($key);
        $this->setShow($show);
    }

    /**
     * @return Show
     */
    public function getShow()
    {
        return $this->show;
    }

    /**
     * @param Show $show
     * @return UserApplication
     */
    public function setShow(Show $show)
    {
        $this->show = $show;

        return $this;
    }
}
