<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplication\ShowDetails;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class UserType
 *
 * @Serializer\XmlRoot("ApplicationType")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package     Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplications\ShowDetails
 */
class ApplicationType
{
    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("ArrayCollection<string>")
     * @Serializer\XmlList(inline = true, entry = "Name")
     * @var array
     */
    private $name;

    /**
     * ApplicationType constructor.
     */
    public function __construct()
    {
        $this->name = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $names
     * @return ApplicationType
     */
    public function addName($name)
    {
        $this->name[] = $name;

        return $this;
    }
}
