<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplicationRole\Show;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class User
 *
 * @Serializer\XmlRoot("User")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package     Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplicationRole\Show
 */
class UserApplicationRole
{

    /**
     * @Serializer\SerializedName("Show")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplicationRole\Show\Show")
     * @var Show
     */
    protected $show;


    /**
     * @param string $identifier
     * @param $applicationName
     */
    public function __construct($identifier = null, $applicationName = null)
    {
        $showModel = new Show();
        $keyModel = new Key();
        $userTypeModel = new UserType();
        $applicationTypeModel = new ApplicationType();
        $userTypeModel->setIdentifier($identifier);
        $applicationTypeModel->setName($applicationName);
        $keyModel->setUserType($userTypeModel);
        $keyModel->setApplicationType($applicationTypeModel);
        $showModel->setKey($keyModel);
        $this->setShow($showModel);
    }

    /**
     * @return Show
     */
    public function getShow()
    {
        return $this->show;
    }

    /**
     * @param Show $show
     * @return $this
     */
    public function setShow($show)
    {
        $this->show = $show;

        return $this;
    }
}
