<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\Advanced;

use JMS\Serializer\Annotation as Serializer;
use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("SsoRequest")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\Advanced
 */
final class Request
{
    /**
     * @Serializer\SerializedName("Credentials")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials")
     * @var Credentials
     */
    protected $credentials;

    /**
     * @Serializer\SerializedName("UserSearch")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\Advanced\UserSearch")
     * @var UserSearch
     */
    private $userSearch;

    /**
     * @param Credentials $credentials
     */
    public function setCredentials(Credentials $credentials)
    {
        $this->credentials = $credentials;
    }

    /**
     * @return Credentials
     */
    public function getCredentials()
    {
        return $this->credentials;
    }

    /**
     * @return UserSearch
     */
    public function getUserSearch()
    {
        return $this->userSearch;
    }

    /**
     * @param UserSearch $userSearch
     * @return Request
     */
    public function setUserSearch(UserSearch $userSearch)
    {
        $this->userSearch = $userSearch;

        return $this;
    }
}
