<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @return Advanced\Factory
     */
    public function advanced()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Advanced\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return FindByApplication\Factory
     */
    public function findByApplication()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new FindByApplication\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return FindByApplicationAttribute\Factory
     */
    public function findByApplicationAttribute()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new FindByApplicationAttribute\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return FindByApplicationRole\Factory
     */
    public function findByApplicationRole()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new FindByApplicationRole\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }
}
