<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\FindByApplicationAttribute;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserSearch
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\FindByApplicationAttribute
 */
class UserSearch
{
    /**
     * @Serializer\SerializedName("FindByApplicationAttribute")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\FindByApplicationAttribute\FindByApplicationAttribute")
     *
     * @var FindByApplicationAttribute
     */
    private $findByApplicationAttribute;

    /**
     * @param string $appName
     * @param integer $appActive
     * @param string $attrName
     * @param string $attrValue
     * @param null|string $modifiedAfter
     */
    public function setUserSearch(
        $appName,
        $appActive,
        $attrName,
        $attrValue,
        $modifiedAfter = null
    ) {
        $applicationType = new ApplicationType();
        $applicationType
            ->setName($appName)
            ->setActive($appActive);

        $attributeType = new AttributeType();
        $attributeType
            ->setName($attrName)
            ->setValue($attrValue);

        $key = new Key();
        $findByApplicationAttribute = new FindByApplicationAttribute();

        if (!empty($modifiedAfter)) {
            $userType = new UserType();
            $userType->setModifiedAfter(new \DateTime($modifiedAfter));

            $key->setUserType($userType);
        }

        $key
            ->setApplicationType($applicationType)
            ->setAttributeType($attributeType);

        $findByApplicationAttribute->setKey($key);

        $this->setFindByApplicationAttribute($findByApplicationAttribute);
    }

    /**
     * @return FindByApplicationAttribute
     */
    public function getFindByApplicationAttribute()
    {
        return $this->findByApplicationAttribute;
    }

    /**
     * @param FindByApplicationAttribute $findByApplicationAttribute
     * @return UserSearch
     */
    public function setFindByApplicationAttribute(FindByApplicationAttribute $findByApplicationAttribute)
    {
        $this->findByApplicationAttribute = $findByApplicationAttribute;

        return $this;
    }
}
