<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\IdpWs\ServiceUser\Get\Success;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 * @package Sso\RestBundle\ModelXml\Response\IdpWs\ServiceUser\Get\Success
 */
class UserType
{
    /**
     * @Serializer\SerializedName("UserIdentifier")
     * @Serializer\Type("string")
     * @var string
     */
    private $userIdentifier;

    /**
     * @Serializer\SerializedName("SessionLifetime")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $sessionLifetime;

    /**
     * @return string
     */
    public function getUserIdentifier()
    {
        return $this->userIdentifier;
    }

    /**
     * @return \DateTime
     */
    public function getSessionLifetime()
    {
        return $this->sessionLifetime;
    }

    /**
     * @param string $userIdentifier
     */
    public function setUserIdentifier($userIdentifier)
    {
        $this->userIdentifier = $userIdentifier;
    }

    /**
     * @param \DateTime $sessionLifetime
     */
    public function setSessionLifetime(\DateTime $sessionLifetime)
    {
        $this->sessionLifetime = $sessionLifetime;
    }
}
