<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\IdpWs\ServiceUser\Validate\Error;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\XmlRoot("SsoRequest")
 */
class Response
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Trackid")
     * @Serializer\Type("string")
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $date;

    /**
     * @Serializer\SerializedName("UserIdentifier")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\IdpWs\ServiceUser\Validate\Error\UserIdentifier")
     * @var UserIdentifier
     */
    private $userIdentifier;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @return UserIdentifier
     */
    public function getUserIdentifier()
    {
        return $this->userIdentifier;
    }

    /**
     * @param string $status
     */
    public function setStatus($status)
    {
        $this->status = $status;
    }

    /**
     * @param string $trackId
     */
    public function setTrackId($trackId)
    {
        $this->trackId = $trackId;
    }

    /**
     * @param string $date
     */
    public function setDate($date)
    {
        $this->date = $date;
    }

    /**
     * @param UserIdentifier $userIdentifier
     */
    public function setUserIdentifier(UserIdentifier $userIdentifier)
    {
        $this->userIdentifier = $userIdentifier;
    }
}
