<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Attribute\Add\Success;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Add
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Attribute\Add\Success
 */
class Add
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Count")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $count;

    /**
     * @Serializer\SerializedName("AttributeType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Attribute\Add\Success\AttributeType")
     *
     * @var AttributeType
     */
    private $attribute;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return Add
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return string
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * @param string $count
     * @return Add
     */
    public function setCount($count)
    {
        $this->count = $count;

        return $this;
    }

    /**
     * @return AttributeType
     */
    public function getAttributeType()
    {
        return $this->attribute;
    }

    /**
     * @param AttributeType $attributeType
     * @return Add
     */
    public function setAttributeType(AttributeType $attributeType)
    {
        $this->attribute = $attributeType;

        return $this;
    }
}
