<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\AttributeGroup\Add\Success;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class AttributeGroupType
 *
 * @Serializer\XmlRoot("Add")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\AttributeGroup\Add\Success
 */
class AttributeGroupType
{
    /**
     * @Serializer\SerializedName("Id")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $id;

    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("Types")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\AttributeGroup\Add\Success\Type>")
     * @Serializer\XmlList(entry="Type")
     *
     * @var Type[]|ArrayCollection
     */
    private $types;

    /**
     * AttributeGroupType constructor.
     */
    public function __construct()
    {
        $this->types = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return AttributeGroupType
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return AttributeGroupType
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return Type[]|ArrayCollection
     */
    public function getTypes()
    {
        return $this->types;
    }

    /**
     * @param Type $type
     * @return AttributeGroupType
     */
    public function setType(Type $type)
    {
        if (!$this->types->contains($type)) {
            $this->types->add($type);
        }

        return $this;
    }
}
