<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\AttributeGroup\Update\Success;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class AttributeGroupType
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\AttributeGroup\Update\Error;
 */
class AttributeGroupType
{
    /**
     * @Serializer\SerializedName("Id")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $id;

    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("Types")
     * @Serializer\Type("ArrayCollection<string>")
     * @Serializer\XmlList(entry="Id")
     *
     * @var string[]|ArrayCollection
     */
    private $typeIds;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return AttributeGroupType
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return AttributeGroupType
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string[]
     */
    public function getTypeIds()
    {
        return $this->typeIds;
    }

    /**
     * @param string $typeId
     * @return AttributeGroupType
     */
    public function addTypeId($typeId)
    {
        if (!$this->typeIds) {
            $this->typeIds = new ArrayCollection();
        }

        if (!$this->typeIds->contains($typeId)) {
            $this->typeIds->add($typeId);
        }

        return $this;
    }
}
