<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object\Delete\ObjectDelete\Error;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * ObjectGetSingle error show
 *
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object\Delete\ObjectDelete\Error
 */
class Show
{
    /**
     * @Serializer\SerializedName("Errors")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object\Delete\ObjectDelete\Error\Error>")
     * @Serializer\XmlList(entry="Error")
     * @var Error[]
     */
    private $error;

    public function __construct()
    {
        $this->error = new ArrayCollection();
    }

    /**
     *
     * @return Error[]
     */
    public function getError()
    {
        return $this->error;
    }

    /**
     *
     * @param Error $error
     */
    public function setError(Error $error)
    {
        $this->error = $error;
    }
}
