<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object\Show\Multi\Success;

use JMS\Serializer\Annotation as Serializer;
use Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object\Show\Multi\Success\Object as SuccessObject;

/**
 * GetObject Handler
 *
 * @Serializer\XmlRoot("SsoResponse")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Response
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $Status;

    /**
     * @Serializer\SerializedName("Trackid")
     * @Serializer\Type("string")
     * @var string
     */
    private $Trackid;

    /**
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("DateTime")
     * @var string
     */
    private $Date;

    /**
     * @Serializer\SerializedName("Object")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object\Show\Multi\Success\Object")
     * @var SuccessObject
     */
    private $object;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     * @return string
     */
    public function getTrackid()
    {
        return $this->Trackid;
    }

    /**
     * @return datetime
     */
    public function getDate()
    {
        return $this->Date;
    }

    /**
     * @return SuccessObject
     */
    public function getObject()
    {
        return $this->object;
    }

    /**
     * @param string $Status
     */
    public function setStatus($Status)
    {
        $this->Status = $Status;
    }

    /**
     * @param string $Trackid
     */
    public function setTrackid($Trackid)
    {
        $this->Trackid = $Trackid;
    }

    /**
     * @param string $Date
     */
    public function setDate($Date)
    {
        $this->Date = $Date;
    }

    /**
     * @param Object $object
     */
    public function setObject(Object $object)
    {
        $this->object = $object;
    }
}
