<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object\Show\Single\Success;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Show
 *
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object\Show\Single\Success
 */
class Show
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Count")
     * @Serializer\Type("string")
     *
     * @var int
     */
    private $count;

    /**
     * @Serializer\SerializedName("Offset")
     * @Serializer\Type("string")
     *
     * @var int
     */
    private $offset;

    /**
     * @Serializer\SerializedName("Limit")
     * @Serializer\Type("string")
     *
     * @var int
     */
    private $limit;

    /**
     * @Serializer\SerializedName("ObjectType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object\Show\Single\Success\ObjectType>")
     * @Serializer\XmlList(inline=true, entry="ObjectType")
     *
     * @var ArrayCollection|ObjectType[]
     */
    private $objectType;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     */
    public function setStatus($status)
    {
        $this->status = $status;
    }

    /**
     * @return int
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * @param int $count
     */
    public function setCount($count)
    {
        $this->count = $count;
    }

    /**
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @param int $offset
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;
    }

    /**
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @param int $limit
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;
    }

    /**
     * @param ObjectType $objectType
     */
    public function setObjectType(ObjectType $objectType)
    {
        if (!$this->objectType) {
            $this->objectType = new ArrayCollection();
        }

        if (!$this->objectType->contains($objectType)) {
            $this->objectType->add($objectType);
        }
    }

    /**
     * @return ArrayCollection|ObjectType[]
     */
    public function getObjectType()
    {
        return $this->objectType;
    }
}
