<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object\Show\Tree\Success;

use JMS\Serializer\Annotation as Serializer;
use Sso\RestBundle\Api\Helper\Mapper\Index as Mapper;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class ObjectType
 *
 * @Serializer\XmlRoot("ShowMulti")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object\Show\Tree\Success
 */
class ObjectType
{
    /**
     * @Serializer\SerializedName("TypeId")
     * @Serializer\Type("string")
     * @var string
     */
    private $typeId;

    /**
     * @Serializer\SerializedName("TypeName")
     * @Serializer\Type("string")
     * @var string
     */
    private $typeName;

    /**
     * @Serializer\SerializedName("TypeOrder")
     * @Serializer\Type("string")
     * @var string
     */
    private $typeOrder;

    /**
     * @Serializer\SerializedName("Guid")
     * @Serializer\Type("string")
     * @var string
     */
    private $guid;

    /**
     * @Serializer\SerializedName("ReferenceId")
     * @Serializer\Type("string")
     * @var string
     */
    private $referenceId;

    /**
     * @Serializer\SerializedName("ParentGuid")
     * @Serializer\Type("string")
     * @var string
     */
    private $parentGuid;

    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("TreeId")
     * @Serializer\Type("string")
     * @var string
     */
    private $treeId;

    /**
     * @Serializer\Exclude()
     *
     * @var Mapper
     */
    private $mapper;

    public function __construct(Mapper $mapper)
    {
        $this->mapper = $mapper;

        $this->children = new ArrayCollection();
        $this->attributes = new ArrayCollection();
    }

    /**
     * @return ArrayCollection
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * @param ArrayCollection $attributes
     * @return ObjectType
     */
    public function setAttributes($attributes)
    {
        $this->attributes = $attributes;
        return $this;
    }

    /**
     * @return ArrayCollection
     */
    public function getChildren()
    {
        return $this->children;
    }

    /**
     * @param ArrayCollection $children
     * @return ObjectType
     */
    public function setChildren($children)
    {
        $this->children = $children;
        return $this;
    }

    /**
     * @return string
     */
    public function getTypeId()
    {
        return $this->typeId;
    }

    /**
     * @param string $typeId
     * @return ObjectType
     */
    public function setTypeId($typeId)
    {
        $this->typeId = $typeId;
        return $this;
    }

    /**
     * @return string
     */
    public function getTypeName()
    {
        return $this->typeName;
    }

    /**
     * @param string $typeName
     * @return ObjectType
     */
    public function setTypeName($typeName)
    {
        $this->typeName = $typeName;
        return $this;
    }

    /**
     * @return string
     */
    public function getTypeOrder()
    {
        return $this->typeOrder;
    }

    /**
     * @param string $typeOrder
     * @return ObjectType
     */
    public function setTypeOrder($typeOrder)
    {
        $this->typeOrder = $typeOrder;
        return $this;
    }

    /**
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @param string $guid
     * @return ObjectType
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;
        return $this;
    }

    /**
     * @return string
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }

    /**
     * @param string $referenceId
     * @return ObjectType
     */
    public function setReferenceId($referenceId)
    {
        $this->referenceId = $referenceId;
        return $this;
    }

    /**
     * @return string
     */
    public function getParentGuid()
    {
        return $this->parentGuid;
    }

    /**
     * @param string $parentGuid
     * @return ObjectType
     */
    public function setParentGuid($parentGuid)
    {
        $this->parentGuid = $parentGuid;
        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return ObjectType
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getTreeId()
    {
        return $this->treeId;
    }

    /**
     * @param string $treeId
     * @return ObjectType
     */
    public function setTreeId($treeId)
    {
        $this->treeId = $treeId;
        return $this;
    }

    /**
     * @return Mapper
     */
    public function getMapper()
    {
        return $this->mapper;
    }

    /**
     * @param Mapper $mapper
     * @return ObjectType
     */
    public function setMapper($mapper)
    {
        $this->mapper = $mapper;
        return $this;
    }
}
