<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object\Update\Success;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Update
 *
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object\Update\Success
 */
class Update
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Message")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $message;

    /**
     * @Serializer\SerializedName("ObjectType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object\Update\Success\ObjectType")
     *
     * @var ObjectType
     */
    private $objectType;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return Update
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param string $message
     * @return Update
     */
    public function setMessage($message)
    {
        $this->message = $message;
        return $this;
    }

    /**
     *
     * @param ObjectType $objectType
     */
    public function setObjectType(ObjectType $objectType)
    {
        $this->objectType = $objectType;
    }

    /**
     *
     * @return ObjectType
     */
    public function getObjectType()
    {
        return $this->objectType;
    }
}
