<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectType\Show\Success;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class TypeType
 *
 * @Serializer\XmlRoot("Show")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectType\Show\Success
 */
class TypeType
{
    /**
     * @Serializer\SerializedName("Id")
     * @Serializer\Type("string")
     * @var string
     */
    private $id;

    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("TypeOrder")
     * @Serializer\Type("string")
     * @var string
     */
    private $order;

    /**
     * @Serializer\SerializedName("AttributeGroups")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectType\Show\Success\AttributeGroup>")
     * @Serializer\XmlList(entry="AttributeGroup")
     *
     * @var AttributeGroup[]|ArrayCollection
     */
    private $attributeGroups;

    /**
     * @Serializer\SerializedName("Created")
     * @Serializer\Type("DateTime")
     * @var string
     */
    private $created;

    /**
     * @Serializer\SerializedName("Updated")
     * @Serializer\Type("DateTime")
     * @var string
     */
    private $updated;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return TypeType
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return TypeType
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @param string $order
     * @return TypeType
     */
    public function setOrder($order)
    {
        $this->order = $order;
        return $this;
    }

    /**
     * @return AttributeGroup[]|ArrayCollection
     */
    public function getAttributeGroups()
    {
        return $this->attributeGroups;
    }

    /**
     * @param AttributeGroup[]|ArrayCollection $attributeGroups
     * @return TypeType
     */
    public function setAttributeGroups($attributeGroups)
    {
        $this->attributeGroups = $attributeGroups;
        return $this;
    }

    /**
     * @return string
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @param string $created
     * @return TypeType
     */
    public function setCreated($created)
    {
        $this->created = $created;
        return $this;
    }

    /**
     * @return string
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * @param string $updated
     * @return TypeType
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;
        return $this;
    }
}
