<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectType\Update\ObjectTypeUpdate\Success;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Update
 *
 * @Serializer\XmlRoot("Type")
 * @package Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectType\Update\ObjectTypeUpdate\Success
 */
class Update
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Count")
     * @Serializer\Type("string")
     * @var string
     */
    private $count;

    /**
     * @Serializer\SerializedName("TypeType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectType\Update\ObjectTypeUpdate\Success\TypeType")
     * @var TypeType
     */
    private $objectType;

    /**
     *
     * @param TypeType $typeType
     */
    public function setTypeType(TypeType $typeType)
    {
        $this->objectType = $typeType;
    }

    /**
     *
     * @return TypeType
     */
    public function getTypeType()
    {
        return $this->objectType;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     */
    public function setStatus($status)
    {
        $this->status = $status;
    }

    /**
     * @return string
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * @param string $count
     */
    public function setCount($count)
    {
        $this->count = $count;
    }
}
