<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectValue\Update\Error;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Error
 *
 * @Serializer\XmlRoot("Errors")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectValue\Update\Error
 */
class Error
{
    /**
     * @Serializer\SerializedName("ErrorCode")
     * @Serializer\Type("string")
     * @var string
     */
    private $errorCode;

    /**
     * @Serializer\SerializedName("ErrorRef")
     * @Serializer\Type("string")
     * @var string
     */
    private $errorRef;

    /**
     * @Serializer\SerializedName("ShortMessage")
     * @Serializer\Type("string")
     * @var string
     */
    private $shortMessage;

    /**
     * @Serializer\SerializedName("LongMessage")
     * @Serializer\Type("string")
     * @var string
     */
    private $longMessage;

    /**
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }

    /**
     * @param string $errorCode
     * @return Error
     */
    public function setErrorCode($errorCode)
    {
        $this->errorCode = $errorCode;

        return $this;
    }

    /**
     * @return string
     */
    public function getErrorRef()
    {
        return $this->errorRef;
    }

    /**
     * @param string $errorRef
     * @return Error
     */
    public function setErrorRef($errorRef)
    {
        $this->errorRef = $errorRef;

        return $this;
    }

    /**
     * @return string
     */
    public function getShortMessage()
    {
        return $this->shortMessage;
    }

    /**
     * @param string $shortMessage
     * @return Error
     */
    public function setShortMessage($shortMessage)
    {
        $this->shortMessage = $shortMessage;

        return $this;
    }

    /**
     * @return string
     */
    public function getLongMessage()
    {
        return $this->longMessage;
    }

    /**
     * @param string $longMessage
     * @return Error
     */
    public function setLongMessage($longMessage)
    {
        $this->longMessage = $longMessage;

        return $this;
    }
}
