<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectValue\Update\Success;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Update
 *
 * @Serializer\XmlRoot("ObjectValue")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectValue\Update\Success
 */
class Update
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("ObjectValueType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectValue\Update\Success\ObjectValueType")
     *
     * @var ObjectValueType
     */
    private $objectValueType;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return Update
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return ObjectValueType
     */
    public function getObjectValueType()
    {
        return $this->objectValueType;
    }

    /**
     * @param ObjectValueType $objectValueType
     * @return Update
     */
    public function setObjectValueType(ObjectValueType $objectValueType)
    {
        $this->objectValueType = $objectValueType;

        return $this;
    }
}
