<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version1\ApplicationRole\Show\Success;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Show
 *
 * @Serializer\XmlRoot("ApplicationRole")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\UserWs\Version1\ApplicationRole\Show\Success
 */
class Show
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("ApplicationRoleType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\UserWs\Version1\ApplicationRole\Show\Success\ApplicationRoleType")
     *
     * @var ApplicationRoleType
     */
    private $applicationRoleType;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return Show
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return ApplicationRoleType
     */
    public function getApplicationRoleType()
    {
        return $this->applicationRoleType;
    }

    /**
     * @param ApplicationRoleType $applicationRoleType
     * @return Show
     */
    public function setApplicationRoleType(ApplicationRoleType $applicationRoleType)
    {
        $this->applicationRoleType = $applicationRoleType;

        return $this;
    }
}
