<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version1\User\Delete\Error;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class User
 *
 * @Serializer\XmlRoot("User")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\UserWs\Version1\User\Delete\Error;
 */
class User
{
    /**
     * @Serializer\SerializedName("Delete")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\UserWs\Version1\User\Delete\Error\Delete")
     *
     * @var Delete
     */
    private $delete;

    /**
     * @return Delete
     */
    public function getDelete()
    {
        return $this->delete;
    }

    /**
     * @param Delete $delete
     */
    public function setDelete(Delete $delete)
    {
        $this->delete = $delete;
    }
}
