<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version1\UserApplication\Add\Error;

use JMS\Serializer\Annotation as Serializer;

/**
 * Error response
 *
 * @Serializer\XmlRoot("SsoResponse")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\UserWs\Version1\UserApplication\Add\Error
 */
class Response
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Trackid")
     * @Serializer\Accessor(getter="getTrackId",setter="setTrackId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $date;

    /**
     * @Serializer\SerializedName("UserApplication")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\UserWs\Version1\UserApplication\Add\Error\UserApplication")
     *
     * @var UserApplication
     */
    private $userApplication;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @return UserApplication
     */
    public function getUserApplication()
    {
        return $this->userApplication;
    }

    /**
     * @param string $status
     * @return Response
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @param string $trackId
     * @return Response
     */
    public function setTrackId($trackId)
    {
        $this->trackId = $trackId;

        return $this;
    }

    /**
     * @param string $date
     * @return Response
     */
    public function setDate($date)
    {
        $this->date = new \DateTime($date);

        return $this;
    }

    /**
     * @param UserApplication $userApplication
     * @return Response
     */
    public function setUserApplication(UserApplication $userApplication)
    {
        $this->userApplication = $userApplication;

        return $this;
    }
}
