<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version1\UserService\ActivateRequest\Success;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\UserWs\Version1\UserService\ActivateRequest\Success
 */
class UserType
{
    /**
     * @Serializer\SerializedName("Username")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("Email")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $email;

    /**
     * @Serializer\SerializedName("ActivateToken")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $activateToken;

    /**
     * @Serializer\SerializedName("ActivateTokenExpire")
     * @Serializer\Type("DateTime<'Y-m-d H:i:s'>")
     *
     * @var \DateTime
     */
    private $activateTokenExpire;

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     *
     * @return UserType
     */
    public function setUsername($username)
    {
        $this->username = $username;

        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     *
     * @return UserType
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @return string
     */
    public function getActivateToken()
    {
        return $this->activateToken;
    }

    /**
     * @param string $activateToken
     *
     * @return $this
     */
    public function setActivateToken($activateToken)
    {
        $this->activateToken = $activateToken;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getActivateTokenExpire()
    {
        return $this->activateTokenExpire;
    }

    /**
     * @param \DateTime $activateTokenExpire
     *
     * @return $this
     */
    public function setActivateTokenExpire($activateTokenExpire)
    {
        $this->activateTokenExpire = $activateTokenExpire;

        return $this;
    }
}
