<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version1\UserService\PasswordRequest\Success;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\UserWs\Version1\UserService\PasswordRequest\Success;
 */
class UserType
{
    /**
     * @Serializer\SerializedName("Username")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("Email")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $email;

    /**
     * @Serializer\SerializedName("PasswordToken")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $passwordToken;

    /**
     * @Serializer\SerializedName("PasswordTokenExpire")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $passwordTokenExpire;

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     * @return UserType
     */
    public function setUsername($username)
    {
        $this->username = $username;

        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return UserType
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @return string
     */
    public function getPasswordToken()
    {
        return $this->passwordToken;
    }

    /**
     * @param string $passwordToken
     * @return UserType
     */
    public function setPasswordToken($passwordToken)
    {
        $this->passwordToken = $passwordToken;

        return $this;
    }

    /**
     * @return string
     */
    public function getPasswordTokenExpire()
    {
        return $this->passwordTokenExpire;
    }

    /**
     * @param string $passwordTokenExpire
     * @return UserType
     */
    public function setPasswordTokenExpire($passwordTokenExpire)
    {
        $this->passwordTokenExpire = $passwordTokenExpire;

        return $this;
    }
}
