<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version2\User\Show\Error;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 *
 * @Serializer\XmlRoot("SsoResponse")
 *
 * Class Response
 * @package Sso\RestBundle\ModelXml\Response\UserWs\Version2\User\Show\Error
 */
class Response
{

    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $Status;

    /**
     * @Serializer\SerializedName("TrackId")
     * @Serializer\Type("string")
     * @var string
     */
    private $TrackId;

    /**
     * @Serializer\SerializedName("Code")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $Code;

    /**
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("DateTime")
     * @var string
     */
    private $Date;

    /**
     * @Serializer\SerializedName("Errors")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelXml\Response\UserWs\Version2\User\Show\Error\Error>")
     * @Serializer\XmlList(entry="Error")
     * @var Errors[]
     */
    private $errors;


    public function __construct()
    {
        $this->errors = new ArrayCollection();
        $this->count = 0;
        $this->statusMessages = [
            200 => 'OK',
            204 => 'No Content',
            400 => 'Bad Request',
            401 => 'Forbidden',
            500 => 'Internal Server Error',
        ];
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->TrackId;
    }

    /**
     * @return datetime
     */
    public function getDate()
    {
        return $this->Date;
    }

    /**
     * @param string $Status
     */
    public function setStatus($Status)
    {
        $this->Status = $Status;
    }

    /**
     * @param string $TrackId
     */
    public function setTrackId($TrackId)
    {
        $this->TrackId = $TrackId;
    }

    /**
     * @param string $Date
     */
    public function setDate($Date)
    {
        $this->Date = $Date;
    }

    /**
     * @return Errors[]
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @param Errors[] $errors
     */
    public function setErrors($errors)
    {
        $this->errors = $errors;
    }


    /**
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }

    /**
     * @param int $Code
     */
    public function setCode($Code)
    {
        $this->Code = $Code;
    }
}