<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version2\User\Update\Error;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Error
 *
 * @Serializer\XmlRoot("Errors")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\UserWs\Version2\User\Update\Error
 */
class Error
{
    /**
     * @Serializer\SerializedName("Code")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $code;

    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("ErrorCode")
     * @Serializer\Type("string")
     * @var string
     */
    private $errorCode;

    /**
     * @Serializer\SerializedName("ErrorReference")
     * @Serializer\Type("string")
     * @var string
     */
    private $errorRef;

    /**
     * @Serializer\SerializedName("ShortMessage")
     * @Serializer\Type("string")
     * @var string
     */
    private $shortMessage;

    /**
     * @Serializer\SerializedName("LongMessage")
     * @Serializer\Type("string")
     * @var string
     */
    private $longMessage;

    /**
     * @Serializer\SerializedName("Type")
     * @Serializer\Type("string")
     * @var string
     */
    private $type;

    /**
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param int $code
     * @return Error
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return Error
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }

    /**
     * @return string
     */
    public function getErrorRef()
    {
        return $this->errorRef;
    }

    /**
     * @return string
     */
    public function getShortMessage()
    {
        return $this->shortMessage;
    }

    /**
     * @return string
     */
    public function getLongMessage()
    {
        return $this->longMessage;
    }

    /**
     * @param string $errorCode
     * @return Error
     */
    public function setErrorCode($errorCode)
    {
        $this->errorCode = $errorCode;

        return $this;
    }

    /**
     * @param string $errorRef
     * @return Error
     */
    public function setErrorRef($errorRef)
    {
        $this->errorRef = $errorRef;

        return $this;
    }

    /**
     * @param string $shortMessage
     * @return Error
     */
    public function setShortMessage($shortMessage)
    {
        $this->shortMessage = $shortMessage;

        return $this;
    }

    /**
     * @param string $longMessage
     * @return Error
     */
    public function setLongMessage($longMessage)
    {
        $this->longMessage = $longMessage;

        return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return Error
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }
}
