<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\Show\Success;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Show
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\UserWs\Version2\User\Show\Success
 */
class Show
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\Show\Success\UserType")
     *
     * @var UserType
     */
    private $userType;

    /**
     * @Serializer\SerializedName("ApplicationType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\Show\Success\ApplicationType>")
     * @Serializer\XmlList(inline=true, entry="ApplicationType")
     *
     * @var ApplicationType[]|ArrayCollection
     */
    private $applicationType;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return Show
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return UserType
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @param UserType $userType
     * @return Show
     */
    public function setUserType(UserType $userType)
    {
        $this->userType = $userType;

        return $this;
    }

    /**
     * @return ApplicationType[]|ArrayCollection
     */
    public function getApplicationType()
    {
        return $this->applicationType;
    }

    /**
     * @param ApplicationType $applicationType
     * @return Show
     */
    public function setApplicationType(ApplicationType $applicationType)
    {
        // prevent empty array in response
        if (!$this->applicationType) {
            $this->applicationType = new ArrayCollection();
        }

        if (!$this->applicationType->contains($applicationType)) {
            $this->applicationType->add($applicationType);
        }

        return $this;
    }
}
