<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\ShowDetails\Success;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("SsoResponse")
 *
 * Class Response
 * @package Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\ShowDetails\Success
 */
class Response
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $Status;

    /**
     * @Serializer\SerializedName("Code")
     * @Serializer\Type("string")
     * @var string
     */
    private $Code;

    /**
     * @Serializer\SerializedName("Trackid")
     * @Serializer\Type("string")
     * @var string
     */
    private $Trackid;

    /**
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("DateTime")
     * @var string
     */
    private $Date;

    /**
     * @Serializer\SerializedName("UserApplication")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\ShowDetails\Success\UserApplication")
     * @var UserApplication
     */
    private $userApplication;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     * @return string
     */
    public function getTrackid()
    {
        return $this->Trackid;
    }

    /**
     * @return datetime
     */
    public function getDate()
    {
        return $this->Date;
    }

    /**
     * @return UserApplication
     */
    public function getUserApplication()
    {
        return $this->userApplication;
    }

    /**
     * @param string $Status
     */
    public function setStatus($Status)
    {
        $this->Status = $Status;
    }

    /**
     * @param string $Trackid
     */
    public function setTrackid($Trackid)
    {
        $this->Trackid = $Trackid;
    }

    /**
     * @param string $Date
     */
    public function setDate($Date)
    {
        $this->Date = $Date;
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }

    /**
     * @param string $Code
     */
    public function setCode($Code)
    {
        $this->Code = $Code;
    }

    /**
     * @param UserApplication $userApplication
     */
    public function setUserApplication(UserApplication $userApplication)
    {
        $this->userApplication = $userApplication;
    }
}
