<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplicationAttribute\Show\Success;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class ApplicationType
 *
 * @Serializer\XmlRoot("ApplicationAttributeType")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplicationAttribute\Show\Success
 */
class ApplicationType
{
    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("Active")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $active;

    /**
     * @Serializer\SerializedName("AttributeType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplicationAttribute\Show\Success\AttributeType>")
     * @Serializer\XmlList(inline=true, entry="AttributeType")
     *
     * @var AttributeType[]|ArrayCollection
     */
    private $attributeType;

    /**
     * ApplicationType constructor.
     */
    public function __construct()
    {
        $this->attributeType = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return ApplicationType
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return integer
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * @param integer $active
     * @return ApplicationType
     */
    public function setActive($active)
    {
        $this->active = $active;

        return $this;
    }

    /**
     * @return AttributeType[]|ArrayCollection
     */
    public function getAttributeType()
    {
        return $this->attributeType;
    }

    /**
     * @param $attributeType
     * @return ApplicationType
     */
    public function setAttributeType(AttributeType $attributeType)
    {
        if (!$this->attributeType->contains($attributeType)) {
            $this->attributeType->add($attributeType);
        }

        return $this;
    }
}
