<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplicationAttribute\Show\Success;

use Sso\RestBundle\ModelXml\Common\Response\UserWs\UserTypeFields;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class ApplicationRoleType
 *
 * @Serializer\XmlRoot("UserApplicationAttribute")
 * @Serializer\AccessorOrder("custom", custom={"guid","username","email","firstName","lastName","active","deleted","createdAt","updatedAt","lastLoginAt","authId","ldapSearchAttributes","ldapSearchValue","mfaEnabled"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplicationAttribute\Show\Success
 */
class UserType
{
    use UserTypeFields;

    /**
     * @Serializer\SerializedName("Deleted")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $deleted;

    /**
     * @Serializer\SerializedName("CreatedAt")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $createdAt;

    /**
     * @Serializer\SerializedName("UpdatedAt")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $updatedAt;

    /**
     * @Serializer\SerializedName("LastLoginAt")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $lastLoginAt;

    /**
     * @Serializer\SerializedName("MfaEnabled")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $mfaEnabled;

    /**
     * @return int
     */
    public function getDeleted()
    {
        return $this->deleted;
    }

    /**
     * @param int $deleted
     * @return UserType
     */
    public function setDeleted($deleted)
    {
        $this->deleted = $deleted;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * @param \DateTime $createdAt
     * @return UserType
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * @param \DateTime $updatedAt
     * @return UserType
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastLoginAt()
    {
        return $this->lastLoginAt;
    }

    /**
     * @param \DateTime $lastLoginAt
     * @return UserType
     */
    public function setLastLoginAt($lastLoginAt)
    {
        $this->lastLoginAt = $lastLoginAt;

        return $this;
    }

    /**
     * @return int
     */
    public function getMfaEnabled()
    {
        return $this->mfaEnabled;
    }

    /**
     * @param int $mfaEnabled
     * @return UserType
     */
    public function setMfaEnabled($mfaEnabled)
    {
        $this->mfaEnabled = $mfaEnabled;

        return $this;
    }
}
