<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplicationRole\Show\Error;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\Annotation\XmlList;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("SsoResponse")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplicationRole\Show\Error
 */
class Response
{
    /**
     * @Serializer\SerializedName("Code")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $code;

    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("TrackId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\SerializedName("Controller")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $controller;

    /**
     * @Serializer\SerializedName("Action")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $action;

    /**
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $date;

    /**
     * @Serializer\SerializedName("ScriptTimeSec")
     * @Serializer\Type("float")
     *
     * @var float
     */
    private $scriptTimeSec;

    /**
     * @Serializer\SerializedName("ErrorCount")
     * @Serializer\Type("int")
     *
     * @var int
     */
    private $errorCount;

    /**
     * @Serializer\SerializedName("Errors")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplicationRole\Show\Error\Error>")
     * @XmlList(entry="Error")
     *
     * @var Error[]|ArrayCollection
     */
    private $errors;

    /**
     * Response constructor
     */
    public function __construct()
    {
        $this->errors = new ArrayCollection();
    }

    /**
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param int $code
     *
     * @return $this
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * @param string $trackId
     *
     * @return $this
     */
    public function setTrackId($trackId)
    {
        $this->trackId = $trackId;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param \DateTime $date
     *
     * @return $this
     */
    public function setDate($date)
    {
        $this->date = $date;

        return $this;
    }

    /**
     * @return float
     */
    public function getScriptTimeSec()
    {
        return $this->scriptTimeSec;
    }

    /**
     * @param float $scriptTimeSec
     *
     * @return $this
     */
    public function setScriptTimeSec($scriptTimeSec)
    {
        $this->scriptTimeSec = $scriptTimeSec;

        return $this;
    }

    /**
     * @return string
     */
    public function getController()
    {
        return $this->controller;
    }

    /**
     * @param string $controller
     *
     * @return Response
     */
    public function setController($controller)
    {
        $this->controller = $controller;

        return $this;
    }

    /**
     * @return string
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * @param string $action
     *
     * @return Response
     */
    public function setAction($action)
    {
        $this->action = $action;

        return $this;
    }

    /**
     * @return int
     */
    public function getErrorCount()
    {
        return $this->errorCount;
    }

    /**
     * @param int $errorCount
     *
     * @return Response
     */
    public function setErrorCount($errorCount)
    {
        $this->errorCount = $errorCount;

        return $this;
    }

    /**
     * @return Error[]|ArrayCollection
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @param Error $error
     *
     * @return Response
     */
    public function setErrors($error)
    {
        if (!$this->errors->contains($error)) {
            $this->errors->add($error);
        }

        return $this;
    }
}
