<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserSearch\FindByApplicationAttribute\Error;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("SsoResponse")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserSearch\FindByApplicationAttribute\Error
 */
class Response
{
    /**
     * @Serializer\SerializedName("Code")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $code;

    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("TrackId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\SerializedName("Controller")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $controller;

    /**
     * @Serializer\SerializedName("Action")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $action;

    /**
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $date;

    /**
     * @Serializer\SerializedName("ScriptTimeSec")
     * @Serializer\Type("float")
     *
     * @var float
     */
    private $scriptTimeSec;

    /**
     * @Serializer\SerializedName("ErrorCount")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $errorCount;

    /**
     * @Serializer\SerializedName("Errors")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserSearch\FindByApplicationAttribute\Error\Error>")
     * @Serializer\XmlList(entry="Error")
     *
     * @var Error[]|ArrayCollection
     */
    private $errors;

    /**
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param int $code
     * @return Response
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return Response
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * @param string $trackId
     * @return Response
     */
    public function setTrackId($trackId)
    {
        $this->trackId = $trackId;

        return $this;
    }

    /**
     * @return string
     */
    public function getController()
    {
        return $this->controller;
    }

    /**
     * @param string $controller
     * @return Response
     */
    public function setController($controller)
    {
        $this->controller = $controller;

        return $this;
    }

    /**
     * @return string
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * @param string $action
     * @return Response
     */
    public function setAction($action)
    {
        $this->action = $action;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param \DateTime $date
     * @return Response
     */
    public function setDate($date)
    {
        $this->date = $date;

        return $this;
    }

    /**
     * @return float
     */
    public function getScriptTimeSec()
    {
        return $this->scriptTimeSec;
    }

    /**
     * @param float $scriptTimeSec
     * @return Response
     */
    public function setScriptTimeSec($scriptTimeSec)
    {
        $this->scriptTimeSec = $scriptTimeSec;

        return $this;
    }

    /**
     * @return int
     */
    public function getErrorCount()
    {
        return $this->errorCount;
    }

    /**
     * @param int $errorCount
     * @return Response
     */
    public function setErrorCount($errorCount)
    {
        $this->errorCount = $errorCount;

        return $this;
    }

    /**
     * @return ArrayCollection|Error[]
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @param ArrayCollection|Error[] $errors
     * @return Response
     */
    public function setErrors($errors)
    {
        $this->errors = $errors;

        return $this;
    }
}
