<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserSearch\FindByApplicationRole\Success;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class FindByApplicationRole
 *
 * @Serializer\XmlRoot("UserSearch")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserSearch\FindByApplicationRole\Success
 */
class FindByApplicationRole
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserSearch\FindByApplicationRole\Success\UserType>")
     * @Serializer\XmlList(inline=true, entry="UserType")
     *
     * @var UserType[]|ArrayCollection
     */
    private $userType;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return FindByApplicationRole
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return UserType[]|ArrayCollection
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @param UserType $userType
     * @return FindByApplicationRole
     */
    public function setUserType(UserType $userType)
    {
        // Prevent empty array in response
        if (!$this->userType) {
            $this->userType = new ArrayCollection();
        }

        if (!$this->userType->contains($userType)) {
            $this->userType->add($userType);
        }

        return $this;
    }
}
