<?php

/**
 * Class BaseTestCase
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\Controller;

use GuzzleHttp\Client as GuzzleClient;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Handler\MockHandler;
use GuzzleHttp\Psr7\Response;
use GuzzleHttp\Psr7\Request as GuzzleRequest;
use GuzzleHttp\HandlerStack;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\RestBundle\Api\Manager as ApiManager;
use Symfony\Bundle\FrameworkBundle\Client;

/**
 * Class BaseTestCase
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Tests\Controller
 */
abstract class BaseTestCase extends WebTestCase
{

    /**
     * @var ApiManager
     */
    protected $apiM;

    /**
     * @var Client
     */
    protected $client;

    /**
     *
     * @var ContainerInterface
     */
    protected $container;

    protected function setUp()
    {
        error_reporting(E_ERROR);
        ini_set('display_errors', 0);

        $this->client = static::createClient();
        $this->container = $this->client->getContainer();
        $this->apiM = new ApiManager($this->container);
    }

    /**
     * Mock client and set a single response
     *
     * @param string $mockedResponse
     * @param array $headers
     * @param int $statusCode
     * @return GuzzleClient
     */
    protected function getMockedClient($mockedResponse, array $headers = [], $statusCode = 200)
    {
        $mock = new MockHandler([
            new Response($statusCode, $headers, $mockedResponse),
        ]);

        $handler = HandlerStack::create($mock);
        return new GuzzleClient(['handler' => $handler]);
    }

    /**
     * Mock client and set multiple responses for multiple requests
     *
     * @param Response[] $responses
     * @return GuzzleClient
     */
    protected function getMockedClientMultipleResponses($responses)
    {
        $mock = new MockHandler($responses);

        $handler = HandlerStack::create($mock);
        return new GuzzleClient(['handler' => $handler]);
    }

    /**
     * Mock client and set an exception response
     *
     * @param string $mockedResponse
     * @param int $statusCode
     * @return GuzzleClient
     */
    protected function getMockedExceptionClient($mockedResponse, $statusCode = 400)
    {
        $mock = new MockHandler([
            new RequestException(
                'No Object Found',
                new GuzzleRequest('GET', 'test'),
                new Response($statusCode, [], $mockedResponse)
            ),
        ]);

        $handler = HandlerStack::create($mock);
        return new GuzzleClient(['handler' => $handler]);
    }

}