<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\Controller;

use Symfony\Component\HttpFoundation\Request;
use GuzzleHttp\Psr7\Response;
use Sso\RestBundle\Worker\UserWs\Version1\Application\Add\Handler as AddHandler;

/**
 * Class AttributeControllerTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Tests\Controller
 */
class ApplicationControllerTest extends BaseTestCase
{
    /**
     * @var string
     */
    private $mockedResponsePath = __DIR__ . '../../../MockedResponse/UserWs/Version1/Application/';

    /**
     * @var string
     */
    private $requestBodyPath = __DIR__ . '../../../RequestBody/UserWs/Version1/Application/';

    /**
     * @var string
     */
    private $expectedResponsePath = __DIR__ . '../../../ExpectedResponse/UserWs/Version1/Application/';

    public function testJsonPostApplicationSuccess()
    {
        // Mock client and set responses (this test is adding multiple items in one call)
        $clientMock = $this->getMockedClientMultipleResponses([
            new Response(200, [], file_get_contents($this->mockedResponsePath . 'Post/success1.xml')),
            new Response(200, [], file_get_contents($this->mockedResponsePath . 'Post/success2.xml')),
        ]);

        $this->apiM->setClient($clientMock);

        $server = [
            'REQUEST_URI' => '/api/v1/application/add.json',
            'REQUEST_METHOD' => 'POST',
        ];

        // Prepare request and set request body and server request settings
        $request = new Request(
            [], [], [], [], [],
            $server,
            file_get_contents($this->requestBodyPath . 'Post/success.json')
        );

        $handler = new AddHandler($this->apiM);
        $view = $handler->init($request);

        $response = $this->container->get('serializer')->serialize($view->getData(), 'json');
        $response = preg_replace('/"ScriptTimeSec["0-9:.]+,/i', '', $response);

        $this->assertEquals(200, $view->getStatusCode());
        $this->assertJsonStringEqualsJsonString(
            file_get_contents($this->expectedResponsePath . 'Post/success.json'),
            $response
        );
    }

    public function testXmlPostApplicationSuccess()
    {
        // Mock client and set responses (this test is adding multiple items in one call)
        $clientMock = $this->getMockedClientMultipleResponses([
            new Response(200, [], file_get_contents($this->mockedResponsePath . 'Post/success1.xml')),
            new Response(200, [], file_get_contents($this->mockedResponsePath . 'Post/success2.xml')),
        ]);

        $this->apiM->setClient($clientMock);

        $server = [
            'REQUEST_URI' => '/api/v1/application/add.xml',
            'REQUEST_METHOD' => 'POST',
        ];

        // Prepare request and set request body and server request settings
        $request = new Request(
            [], [], [], [], [],
            $server,
            file_get_contents($this->requestBodyPath . 'Post/success.xml')
        );

        $handler = new AddHandler($this->apiM);
        $view = $handler->init($request);

        $response = $this->container->get('serializer')->serialize($view->getData(), 'xml');
        $response = preg_replace('/<scriptTimeSec>(.*?)<\/scriptTimeSec>/i', '', $response);

        $this->assertEquals(200, $view->getStatusCode());
        $this->assertXmlStringEqualsXmlString(
            file_get_contents($this->expectedResponsePath . 'Post/success.xml'),
            $response
        );
    }

    public function testJsonPostApplicationError()
    {
        // Mock client and set responses (this test is adding multiple items in one call)
        $clientMock = $this->getMockedClientMultipleResponses([
            new Response(400, [], file_get_contents($this->mockedResponsePath . 'Post/error.xml'))
        ]);

        $this->apiM->setClient($clientMock);

        $server = [
            'REQUEST_URI' => '/api/v1/application/add.json',
            'REQUEST_METHOD' => 'POST',
        ];

        // Prepare request and set request body and server request settings
        $request = new Request(
            [], [], [], [], [],
            $server,
            file_get_contents($this->requestBodyPath . 'Post/error.json')
        );

        $handler = new AddHandler($this->apiM);
        $view = $handler->init($request);

        $response = $this->container->get('serializer')->serialize($view->getData(), 'json');
        $response = preg_replace('/"ScriptTimeSec["0-9:.]+,/i', '', $response);

        $this->assertEquals(400, $view->getStatusCode());
        $this->assertJsonStringEqualsJsonString(
            file_get_contents($this->expectedResponsePath . 'Post/error.json'),
            $response
        );
    }

    public function testXmlPostApplicationError()
    {
        // Mock client and set responses (this test is adding multiple items in one call)
        $clientMock = $this->getMockedClientMultipleResponses([
            new Response(400, [], file_get_contents($this->mockedResponsePath . 'Post/error.xml'))
        ]);

        $this->apiM->setClient($clientMock);

        $server = [
            'REQUEST_URI' => '/api/v1/application/add.xml',
            'REQUEST_METHOD' => 'POST',
        ];

        // Prepare request and set request body and server request settings
        $request = new Request(
            [], [], [], [], [],
            $server,
            file_get_contents($this->requestBodyPath . 'Post/error.xml')
        );

        $handler = new AddHandler($this->apiM);
        $view = $handler->init($request);

        $response = $this->container->get('serializer')->serialize($view->getData(), 'xml');
        $response = preg_replace('/<scriptTimeSec>(.*?)<\/scriptTimeSec>/i', '', $response);

        $this->assertEquals(400, $view->getStatusCode());
        $this->assertXmlStringEqualsXmlString(
            file_get_contents($this->expectedResponsePath . 'Post/error.xml'),
            $response
        );
    }
}
