<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Common\Type;

use Sso\RestBundle\ModelRest\Common\Type\ArrayStringType;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class ArrayStringContainer
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelRest\Common\Type
 * @Serializer\XmlRoot(name="root")
 */
class ArrayStringContainer
{
    /**
     * @Serializer\SerializedName("stringValue")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Common\Type\ArrayStringType")
     *
     * @var ArrayStringType
     */
    private $stringValue;

    /**
     * @Serializer\SerializedName("arrayValue")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Common\Type\ArrayStringType")
     *
     * @var ArrayStringType
     */
    private $arrayValue;

    /**
     * @return ArrayStringType
     */
    public function getStringValue()
    {
        return $this->stringValue;
    }

    /**
     * @param ArrayStringType $stringValue
     */
    public function setStringValue(ArrayStringType $stringValue)
    {
        $this->stringValue = $stringValue;
    }

    /**
     * @return ArrayStringType
     */
    public function getArrayValue()
    {
        return $this->arrayValue;
    }

    /**
     * @param ArrayStringType $arrayValue
     */
    public function setArrayValue(ArrayStringType $arrayValue)
    {
        $this->arrayValue = $arrayValue;
    }
}
