<?php

/**
 * Test class ModelRest Request Object Factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Request\Object;

use GuzzleHttp\Client;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\RestBundle\Api;
use Sso\RestBundle\ModelRest;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Test class ModelRest Request Object Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class FactoryBaseTest extends WebTestCase
{

    /**
     *
     * @var Api\Manager
     */
    public $apiM;

    /**
     *
     * @var Client
     */
    protected $client;

    /**
     *
     * @var ContainerInterface
     */
    protected $container;

    protected function setUp()
    {
        $this->client = static::createClient();
        $this->container = $this->client->getContainer();
        $this->apiM = new Api\Manager($this->container);
    }

    public function testGetRequest()
    {
        // asserts
        $this->assertInstanceOf('\Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\Object\Show\Single\Request',
            $this->apiM->modelRest()->request()->objectWs()->version1()->object()->show()->single());
    }

    public function testPostRequest()
    {
        // asserts
        $this->assertInstanceOf('\Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\Object\Add\Request',
            $this->apiM->modelRest()->request()->objectWs()->version1()->object()->add());
    }
}
