<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Request\ObjectWs\Version1\ObjectValue\Update;

use Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\ObjectValue\Update\ObjectValueType;
use Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\ObjectValue\Update\Request;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\RestBundle\Api\Manager as ApiManager;
use JMS\Serializer\SerializerInterface;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;

/**
 * Class RequestTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelRest
 */
class RequestTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var string
     */
    private $id;

    /**
     * @var string
     */
    private $value;

    /**
     * @var string
     */
    private $languageCode;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        // Set same random data
        $this->id = $this->faker->sha1;
        $this->value = $this->faker->word;
        $this->languageCode = $this->faker->languageCode;
    }

    public function testJsonSerialize()
    {
        $this->assertJsonStringEqualsJsonString($this->getRequestBody('json'), $this->setRequestBody('json'));
    }

    public function testXmlSerialize()
    {
        $this->assertXmlStringEqualsXmlString($this->getRequestBody('xml'), $this->setRequestBody('xml'));
    }

    /**
     * @param string $type (xml | json)
     * @return string
     */
    private function setRequestBody($type = 'xml')
    {
        $request = new Request();
        $objectValueType = new ObjectValueType();

        $objectValueType
            ->setId($this->id)
            ->setValue($this->value)
            ->setLanguageCode($this->languageCode);

        $request->setObjectValueType($objectValueType);

        return $this->serializer->serialize($request, ($type !== 'json' ? 'xml' : 'json'));
    }

    /**
     * @param string $type (xml | json)
     * @return string
     */
    private function getRequestBody($type = 'xml')
    {
        if ($type === 'json') {
            return '{
                "values": [
                    {
                        "id": "' . $this->id . '",
                        "value": "' . $this->value . '",
                        "languageCode": "' . $this->languageCode . '"
                    }
                ]
            }';
        } else {
            return '<objectValueUpdate>
                <values>
                    <objectValueType>
                        <id><![CDATA[' . $this->id . ']]></id>
                        <value><![CDATA[' . $this->value . ']]></value>
                        <languageCode><![CDATA[' . $this->languageCode . ']]></languageCode>
                    </objectValueType>
                </values>
            </objectValueUpdate>';
        }
    }

    public function testGetters()
    {
        /** @var  Request $requestModel */
        $requestModel = $this->serializer->deserialize(
            $this->setRequestBody('json'),
            Request::class,
            'json'
        );

        $objectValueType = $requestModel->getObjectValueType()->get(0);

        $this->assertEquals($this->id, $objectValueType->getId());
        $this->assertEquals($this->value, $objectValueType->getValue());
        $this->assertEquals($this->languageCode, $objectValueType->getLanguageCode());
    }
}
