<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Request\UserWs\Version1\ApplicationRole\Add;

use Sso\RestBundle\ModelRest\Request\UserWs\Version1\ApplicationRole\Add\ApplicationType;
use Sso\RestBundle\ModelRest\Request\UserWs\Version1\ApplicationRole\Add\RoleType;
use Sso\RestBundle\ModelRest\Request\UserWs\Version1\ApplicationRole\Add\Request;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\RestBundle\Api\Manager as ApiManager;
use JMS\Serializer\SerializerInterface;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;

/**
 * Class RequestTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelRest
 */
class RequestTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $description;

    /**
     * @var string
     */
    private $active;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        // Set same random data
        $this->name = $this->faker->name;
        $this->description = $this->faker->sentence();
        $this->active = $this->faker->boolean ? 1 : 0;
    }

    public function testJsonSerialize()
    {
        $this->assertJsonStringEqualsJsonString($this->getRequestBody('json'), $this->setRequestBody('json'));
    }

    public function testXmlSerialize()
    {
        $this->assertXmlStringEqualsXmlString($this->getRequestBody('xml'), $this->setRequestBody('xml'));
    }

    /**
     * @param string $type (xml | json)
     * @return string
     */
    private function setRequestBody($type = 'xml')
    {
        $request = new Request();
        $roleType = new RoleType();
        $applicationType = new ApplicationType();

        $applicationType->setName($this->name);
        $roleType
            ->setName($this->name)
            ->setDescription($this->description)
            ->setApplicationType($applicationType);

        $request->addRoleType($roleType);

        return $this->serializer->serialize($request, ($type !== 'json' ? 'xml' : 'json'));
    }

    /**
     * @param string $type (xml | json)
     * @return string
     */
    private function getRequestBody($type = 'xml')
    {
        if ($type === 'json') {
            return '{
                "roles": [
                    {
                        "name": "' . $this->name . '",
                        "description": "' . $this->description . '",
                        "applicationType": {
                            "name": "' . $this->name . '"
                        }
                    }
                ]
            }';
        } else {
            return '<applicationRoleAdd>
                <roles>
                    <roleType>
                        <name><![CDATA[' . $this->name . ']]></name>
                        <description><![CDATA[' . $this->description . ']]></description>
                        <applicationType>
                            <name><![CDATA[' . $this->name . ']]></name>
                        </applicationType>
                    </roleType>
                </roles>
            </applicationRoleAdd>';
        }
    }

    public function testGetterAttributeType()
    {
        /** @var  Request $requestModel */
        $requestModel = $this->serializer->deserialize(
            $this->setRequestBody('json'),
            Request::class,
            'json'
        );

        $attributeType = $requestModel->getRoleType()->get(0);

        $this->assertEquals($this->name, $attributeType->getName());
        $this->assertEquals($this->description, $attributeType->getDescription());
        $this->assertEquals($this->name, $attributeType->getApplicationType()->getName());
    }

    public function testSetterGetterApplicationType()
    {
        $applicationType = new ApplicationType();
        $applicationType->setName($this->name);
        $this->assertEquals($this->name, $applicationType->getName());
    }
}
