<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Request\UserWs\Version1\User;

use Sso\RestBundle\ModelRest\Request\UserWs\Version1\User\Add;
use Sso\RestBundle\ModelRest\Request\UserWs\Version1\User\Delete;
use Sso\RestBundle\ModelRest\Request\UserWs\Version1\User\Factory;
use Sso\RestBundle\ModelRest\Request\UserWs\Version1\User\Show;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelRest\Request\UserWs\Version1\User
 */
class FactoryTest extends TestCase
{
    /**
     * @var Factory
     */
    private $factory;

    public function setUp()
    {
        $this->factory = new Factory();
    }

    public function testAddRequest()
    {
        self::assertInstanceOf(Add\Request::class, $this->factory->add());
    }

    public function testShowRequest()
    {
        self::assertInstanceOf(Show\Request::class, $this->factory->show());
    }

    public function testDeleteRequest()
    {
        self::assertInstanceOf(Delete\Request::class, $this->factory->delete());
    }
}
