<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Delete;

use Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Delete\ApplicationType;
use Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Delete\Request;
use Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Delete\UserAttributeType;
use Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Delete\UserType;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\RestBundle\Api\Manager as ApiManager;
use JMS\Serializer\SerializerInterface;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;

/**
 * Class RequestTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelRest
 */
class RequestTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var string
     */
    private $identifier;

    /**
     * @var string
     */
    private $appName;

    /**
     * @var string
     */
    private $attrName;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        // Set same random data
        $this->identifier = $this->faker->userName;
        $this->appName = $this->faker->word;
        $this->attrName = $this->faker->word;
    }

    public function testJsonSerialize()
    {
        $this->assertJsonStringEqualsJsonString($this->getRequestBody('json'), $this->setRequestBody('json'));
    }

    public function testXmlSerialize()
    {
        $this->assertXmlStringEqualsXmlString($this->getRequestBody('xml'), $this->setRequestBody('xml'));
    }

    /**
     * @param string $type (xml | json)
     * @return string
     */
    private function setRequestBody($type = 'xml')
    {
        $request = new Request();
        $userAttributeType = new UserAttributeType();
        $applicationType = new ApplicationType();
        $userType = new UserType();

        $applicationType->setName($this->appName);
        $userType->setIdentifier($this->identifier);
        $userAttributeType
            ->setName($this->attrName)
            ->setApplicationType($applicationType)
            ->setUserType($userType);
        $request->addUserAttributeType($userAttributeType);

        return $this->serializer->serialize($request, ($type !== 'json' ? 'xml' : 'json'));
    }

    /**
     * @param string $type (xml | json)
     * @return string
     */
    private function getRequestBody($type = 'xml')
    {
        if ($type === 'json') {
            return '{
                "userAttributes": [
                    {
                        "name": "' . $this->attrName . '",
                        "applicationType": {
                            "name": "' . $this->appName . '"
                        },
                        "userType": {
                            "identifier": "' . $this->identifier . '"
                        }
                    }
                ]
            }';
        } else {
            return '<userAttributeDelete>
                <userAttributes>
                    <userAttributeType>
                        <name><![CDATA[' . $this->attrName . ']]></name>
                        <applicationType>
                            <name><![CDATA[' . $this->appName . ']]></name>
                        </applicationType>
                        <userType>
                            <identifier><![CDATA[' . $this->identifier . ']]></identifier>
                        </userType>
                    </userAttributeType>
                </userAttributes>
            </userAttributeDelete>';
        }
    }

    public function testGetterUserAttributeType()
    {
        /** @var  Request $requestModel */
        $requestModel = $this->serializer->deserialize(
            $this->setRequestBody('json'),
            Request::class,
            'json'
        );

        $userAttributeType = $requestModel->getUserAttributeType()->get(0);

        $this->assertEquals($this->attrName, $userAttributeType->getName());
        $this->assertEquals($this->appName, $userAttributeType->getApplicationType()->getName());
        $this->assertEquals($this->identifier, $userAttributeType->getUserType()->getIdentifier());
    }
}
