<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Request\UserWs\Version1\UserApplicationAttribute;

use Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Factory;
use Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Add\Request as AddRequest;
use Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Show\Request as ShowRequest;
use Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Delete\Request as DeleteRequest;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelRest\Request\UserWs\Version1\UserApplicationAttribute
 */
class FactoryTest extends TestCase
{
    /**
     * @var Factory
     */
    private $factory;

    protected function setUp()
    {
        $this->factory = new Factory();
    }

    public function testAddRequest()
    {
        $this->assertInstanceOf(AddRequest::class, $this->factory->add());
    }

    public function testShowRequest()
    {
        $this->assertInstanceOf(ShowRequest::class, $this->factory->show());
    }

    public function testDeleteRequest()
    {
        $this->assertInstanceOf(DeleteRequest::class, $this->factory->delete());
    }
}
