<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Request\UserWs\Version2\UserApplication;

use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserApplication\Factory;
use Sso\RestBundle\ModelRest\Request\UserWS\Version2\UserApplication\Show\Request as ShowRequest;
use Sso\RestBundle\ModelRest\Request\UserWS\Version2\UserApplication\ShowDetails\Request as ShowDetailsRequest;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class FactoryTest extends TestCase
{
    /**
     * @var Factory
     */
    private $factory;

    public function setUp()
    {
        $this->factory = new Factory();
    }

    public function testShowRequest()
    {
        $this->assertInstanceOf(ShowRequest::class, $this->factory->show());
    }

    public function testShowDetailsRequestRequest()
    {
        $this->assertInstanceOf(ShowDetailsRequest::class, $this->factory->showDetails());
    }
}
