<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationAttribute;

use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationAttribute\ApplicationType;
use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationAttribute\AttributeType;
use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationAttribute\Request;
use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationAttribute\UserByAttribute;
use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationAttribute\UserType;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\RestBundle\Api\Manager as ApiManager;
use JMS\Serializer\SerializerInterface;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;

/**
 * Class RequestTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelRest
 */
class RequestTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var string
     */
    private $modified;

    /**
     * @var string
     */
    private $appName;

    /**
     * @var integer
     */
    private $appActive;

    /**
     * @var string
     */
    private $attrName;

    /**
     * @var string
     */
    private $attrValue;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        // Set same random data
        $this->modified = '2099-01-01T00:00:00+00:00';
        $this->appName = $this->faker->word;
        $this->appActive = $this->faker->boolean ? 1 : 0;
        $this->attrName = $this->faker->word;
        $this->attrValue = $this->faker->word;
    }

    public function testJsonSerialize()
    {
        $this->assertJsonStringEqualsJsonString($this->getRequestBody('json'), $this->setRequestBody('json'));
    }

    public function testXmlSerialize()
    {
        $this->assertXmlStringEqualsXmlString($this->getRequestBody('xml'), $this->setRequestBody('xml'));
    }

    /**
     * @param string $type (xml | json)
     * @return string
     */
    private function setRequestBody($type = 'xml')
    {
        $request = new Request();
        $userByAttribute = new UserByAttribute();
        $userType = new UserType();
        $applicationType = new ApplicationType();
        $attributeType = new AttributeType();

        $applicationType
            ->setName($this->appName)
            ->setActive($this->appActive);

        $attributeType
            ->setName($this->attrName)
            ->setValue($this->attrValue);

        $userType
            ->setModified($this->modified)
            ->setApplicationType($applicationType)
            ->setAttributeType($attributeType);

        $userByAttribute->setUserType($userType);

        $request->setUserByAttribute($userByAttribute);

        return $this->serializer->serialize($request, ($type !== 'json' ? 'xml' : 'json'));
    }

    /**
     * @param string $type (xml | json)
     * @return string
     */
    private function getRequestBody($type = 'xml')
    {
        if ($type === 'json') {
            return '{
              "userByAttribute": {
                  "userType": {
                    "modified": "' . $this->modified . '",
                    "applicationType": {
                      "name": "' . $this->appName . '",
                      "active": ' . $this->appActive . '
                    },
                    "attributeType": {
                      "name": "' . $this->attrName . '",
                      "value": "' . $this->attrValue . '"
                    }
                  }
              }
            }';
        } else {
            return '<userSearchByAttribute>
                <userByAttribute>
                    <userType>
                        <modified><![CDATA[' . $this->modified . ']]></modified>
                        <applicationType>
                            <name><![CDATA[' . $this->appName . ']]></name>
                            <active>' . $this->appActive . '</active>
                        </applicationType>
                        <attributeType>
                            <name><![CDATA[' . $this->attrName . ']]></name>
                            <value><![CDATA[' . $this->attrValue . ']]></value>
                        </attributeType>
                    </userType>
                </userByAttribute>
            </userSearchByAttribute>';
        }
    }

    public function testGetterUserSearchByAttribute()
    {
        /** @var  Request $requestModel */
        $requestModel = $this->serializer->deserialize(
            $this->setRequestBody('json'),
            Request::class,
            'json'
        );

        $this->assertEquals($this->modified, $requestModel->getUserByAttribute()->getUserType()->getModified());
        $this->assertEquals($this->appName,
            $requestModel->getUserByAttribute()->getUserType()->getApplicationType()->getName());
        $this->assertEquals($this->appActive,
            $requestModel->getUserByAttribute()->getUserType()->getApplicationType()->getActive());
        $this->assertEquals($this->attrName,
            $requestModel->getUserByAttribute()->getUserType()->getAttributeType()->getName());
        $this->assertEquals($this->attrValue,
            $requestModel->getUserByAttribute()->getUserType()->getAttributeType()->getValue());
    }
}
