<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationRole;

use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationRole\ApplicationType;
use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationRole\RoleType;
use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationRole\Request;
use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationRole\UserByRole;
use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationRole\UserType;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\RestBundle\Api\Manager as ApiManager;
use JMS\Serializer\SerializerInterface;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;

/**
 * Class RequestTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelRest
 */
class RequestTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var string
     */
    private $modified;

    /**
     * @var string
     */
    private $appName;

    /**
     * @var integer
     */
    private $appActive;

    /**
     * @var string
     */
    private $roleName;

    /**
     * @var string
     */
    private $roleActive;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        // Set same random data
        $this->modified = '2099-01-01T00:00:00+00:00';
        $this->appName = $this->faker->word;
        $this->appActive = $this->faker->boolean ? 1 : 0;
        $this->roleName = $this->faker->word;
        $this->roleActive = $this->faker->boolean ? 1 : 0;
    }

    public function testJsonSerialize()
    {
        $this->assertJsonStringEqualsJsonString($this->getRequestBody('json'), $this->setRequestBody('json'));
    }

    public function testXmlSerialize()
    {
        $this->assertXmlStringEqualsXmlString($this->getRequestBody('xml'), $this->setRequestBody('xml'));
    }

    /**
     * @param string $type (xml | json)
     * @return string
     */
    private function setRequestBody($type = 'xml')
    {
        $request = new Request();
        $userByRole = new UserByRole();
        $userType = new UserType();
        $applicationType = new ApplicationType();
        $roleType = new RoleType();

        $applicationType
            ->setName($this->appName)
            ->setActive($this->appActive);

        $roleType
            ->setName($this->roleName)
            ->setActive($this->roleActive);

        $userType
            ->setModified($this->modified)
            ->setApplicationType($applicationType)
            ->setRoleType($roleType);

        $userByRole->setUserType($userType);

        $request->setUserByRole($userByRole);

        return $this->serializer->serialize($request, ($type !== 'json' ? 'xml' : 'json'));
    }

    /**
     * @param string $type (xml | json)
     * @return string
     */
    private function getRequestBody($type = 'xml')
    {
        if ($type === 'json') {
            return '{
              "userByRole": {
                  "userType": {
                    "modified": "' . $this->modified . '",
                    "applicationType": {
                      "name": "' . $this->appName . '",
                      "active": ' . $this->appActive . '
                    },
                    "roleType": {
                      "roleName": "' . $this->roleName . '",
                      "roleActive": "' . $this->roleActive . '"
                    }
                  }
              }
            }';
        } else {
            return '<userSearchByRole>
                <userByRole>
                    <userType>
                        <modified><![CDATA[' . $this->modified . ']]></modified>
                        <applicationType>
                            <name><![CDATA[' . $this->appName . ']]></name>
                            <active>' . $this->appActive . '</active>
                        </applicationType>
                        <roleType>
                            <roleName><![CDATA[' . $this->roleName . ']]></roleName>
                            <roleActive><![CDATA[' . $this->roleActive . ']]></roleActive>
                        </roleType>
                    </userType>
                </userByRole>
            </userSearchByRole>';
        }
    }

    public function testGetterUserSearchByRole()
    {
        /** @var  Request $requestModel */
        $requestModel = $this->serializer->deserialize(
            $this->setRequestBody('json'),
            Request::class,
            'json'
        );

        $this->assertEquals($this->modified, $requestModel->getUserByRole()->getUserType()->getModified());
        $this->assertEquals($this->appName,
            $requestModel->getUserByRole()->getUserType()->getApplicationType()->getName());
        $this->assertEquals($this->appActive,
            $requestModel->getUserByRole()->getUserType()->getApplicationType()->getActive());
        $this->assertEquals($this->roleName, $requestModel->getUserByRole()->getUserType()->getRoleType()->getName());
        $this->assertEquals($this->roleActive,
            $requestModel->getUserByRole()->getUserType()->getRoleType()->getActive());
    }
}
