<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Response\MultipleWs\Version1\Object\Scope\Tree\Success;

use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use Sso\RestBundle\ModelRest\Response\MultipleWs\Version1\Object\Scope\Tree\Success;
use PHPUnit\Framework\TestCase;

/**
 * Class ResponseTest
 * @package Sso\RestBundle\Tests\ModelRest\Response\MultipleWs\Version1\Object\Scope\Tree\Success
 */
class ResponseTest extends TestCase
{
    public function testResponseModel()
    {
        /** @var Serializer $serializer */
        $serializer = SerializerBuilder::create()->build();

        $responseModel = new Success\Response();
        $responseModel->setOffset(13);
        $responseModel->setLimit(37);
        $responseModel->setCount(42);
        $responseModel->setCode(200);
        $responseModel->setMessage('Hullo');
        $responseModel->setScriptTimeSec(3.141);
        $responseModel->setTrackId('TEST00000');

        $responseObject = new Success\ObjectType();
        $responseObject->setName('TestObject');
        $responseObject->setGuid('00000000-0000-0000-0000-000000000000');
        $responseObject->setReferenceId('REF0000');
        $responseObject->setScopeType('test');
        $responseObject->setTreeId('1.02.03.04');
        $responseObject->setTypeName('Testthing');

        $responseModel->addObject($responseObject);

        $responseJson = $serializer->serialize($responseModel, 'json');
        $expectedJson = '{"code":200,"status":"OK","message":"Hullo","trackId":"TEST00000","scriptTimeSec":3.141,"count":"42","offset":"13","limit":"37","scopeTree":[{"typeName":"Testthing","guid":"00000000-0000-0000-0000-000000000000","referenceId":"REF0000","name":"TestObject","treeId":"1.02.03.04","scopeType":"test"}]}';

        $this->assertEquals($expectedJson, $responseJson);
    }
}
