<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Response\ObjectWs\Version1\AttributeGroup;

use Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelRest\Response\ObjectWs\Version1\AttributeGroup
 */
class FactoryTest extends TestCase
{
    /**
     * @var AttributeGroup\Factory
     */
    private $factory;

    /**
     * {@inheritDoc}
     */
    public function setUp()
    {
        $this->factory = new AttributeGroup\Factory();
    }

    public function testAddFactory()
    {
        static::assertInstanceOf(AttributeGroup\Add\Factory::class, $this->factory->add());
    }

    public function testDeleteFactory()
    {
        static::assertInstanceOf(AttributeGroup\Delete\Factory::class, $this->factory->delete());
    }

    public function testShowFactory()
    {
        static::assertInstanceOf(AttributeGroup\Show\Factory::class, $this->factory->show());
    }

    public function testUpdateFactory()
    {
        static::assertInstanceOf(AttributeGroup\Update\Factory::class, $this->factory->update());
    }
}
