<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Update;

use Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector;
use Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Update;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Add
 */
class FactoryTest extends TestCase
{
    /**
     * @var Update\Factory
     */
    private $factory;

    public function setUp()
    {
        $this->factory = new Update\Factory();
    }

    public function testResponseFactory()
    {
        static::assertInstanceOf(Update\Response::class, $this->factory->response());
    }

    public function testAttributeGroupFactory()
    {
        static::assertInstanceOf(Update\AttributeGroup::class, $this->factory->attributeGroup());
    }

    public function testErrorFactory()
    {
        static::assertInstanceOf(ErrorCollector\Error::class, $this->factory->error());
    }
}
