<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Response\ObjectWs\Version1\Object\Add;

use PHPUnit\Framework\TestCase;
use Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Add\Factory;
use Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Add as RestResponse;
use Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelRest\Response\ObjectWs\Version1\Object\Add
 */
class FactoryTest extends TestCase
{
    /**
     * @var Factory
     */
    private $factory;

    public function setUp()
    {
        $this->factory = new Factory();
        parent::setUp();
    }

    public function testObject()
    {
        $this->assertInstanceOf(RestResponse\Object::class, $this->factory->object());
    }

    public function testResponse()
    {
        $this->assertInstanceOf(RestResponse\Response::class, $this->factory->response());
    }


    public function testError()
    {
        $this->assertInstanceOf(ErrorCollector\Error::class, $this->factory->error());
    }
}
